#ifndef MAINWINDOW_H
#define MAINWINDOW_H
/*
Copyright (c) 2018 Triethic By Gaia

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name(s) of the
above copyright holders shall not be used in advertising
or otherwise to promote the sale, use or other dealings
in this Software or parts of it without prior written
authorization.
*/
#include <QMainWindow>

namespace Ui {
  class MainWindow;
}
class QNetworkAccessManager;
class QCloseEvent;
class MainWindow : public QMainWindow
{
  Q_OBJECT

public:
  explicit MainWindow(QWidget *parent = nullptr);
  ~MainWindow();
protected:
  void closeEvent(QCloseEvent *event);
private slots:
  void on_responseBody_textChanged();
  void on_send_clicked();
  void on_body_textChanged();

  void on_action_Quit_triggered();

  void on_actionQt_triggered();

  void on_actionApIOR_triggered();

private:
  Ui::MainWindow *ui;
  QNetworkAccessManager* networkAccessManager;
  QString login;
  QString password;
  QString proxyLogin;
  QString proxyPassword;
  QString preSharedKeyLogin;
  QString preSharedKeyPassword;
};

#endif // MAINWINDOW_H
